<?php
session_start();
include 'conexao.php';

// 1. VERIFICAÇÃO DE PERMISSÃO: Apenas Administradores podem simular.
if (!isset($_SESSION['usuario']) || strtoupper($_SESSION['usuario']['perfil']) !== 'SUBDIRECÇÃO PEDAGÓGICA'   ) {
    die("Acesso negado. Apenas o Diretor Geral pode simular o acesso.");
}

// 2. O ID do professor alvo deve ser passado na URL.
$target_id = $_GET['target_id'] ?? null;
if (!$target_id || !is_numeric($target_id)) {
    die("ID do usuário alvo inválido.");
}

// 3. Consulta para buscar os dados do professor alvo.
$stmt = $conn->prepare("SELECT id, nome, perfil, foto FROM usuarios WHERE id = ? AND perfil = 'PROFESSOR'");
$stmt->bind_param("i", $target_id);
$stmt->execute();
$result = $stmt->get_result();
$professor_alvo = $result->fetch_assoc();
$stmt->close();
$conn->close();

if (!$professor_alvo) {
    die("Professor alvo não encontrado.");
}

// 4. LÓGICA DE SIMULAÇÃO: Armazena o usuário REAL para poder retornar.

// Armazena a sessão do Diretor em uma variável temporária
$_SESSION['diretor_original'] = $_SESSION['usuario']; 
$_SESSION['simulando'] = true; // Flag para indicar que está simulando

// Substitui a sessão pelo usuário alvo (o professor)
$_SESSION['usuario'] = $professor_alvo;

// 5. REDIRECIONAMENTO: Envia o diretor para o painel do professor.
header("Location: painel_professor1.php"); // Altere para o painel real do professor
exit;

// O painel do professor (painel_professor1.php) deve ser o mesmo usado pelos professores, 
// e ele se baseará na nova $_SESSION['usuario'].
?>